/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.dungeons;

import com.badlogic.gdx.graphics.Color;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.localization.UIStrings;
import com.megacrit.cardcrawl.monsters.MonsterInfo;
import com.megacrit.cardcrawl.random.Random;
import com.megacrit.cardcrawl.scenes.TheBeyondScene;
import com.megacrit.cardcrawl.screens.saveAndContinue.SaveFile;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TheBeyond
extends AbstractDungeon {
    private static final Logger logger = LogManager.getLogger(TheBeyond.class.getName());
    private static final UIStrings uiStrings = CardCrawlGame.languagePack.getUIString("TheBeyond");
    public static final String[] TEXT = TheBeyond.uiStrings.TEXT;
    public static final String NAME = TEXT[0];
    public static final String ID = "TheBeyond";

    public TheBeyond(AbstractPlayer p, ArrayList<String> theList) {
        super(NAME, ID, p, theList);
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheBeyondScene();
        fadeColor = Color.valueOf("140a1eff");
        this.initializeLevelSpecificChances();
        mapRng = new Random(Settings.seed, 200);
        TheBeyond.generateMap();
        CardCrawlGame.music.changeBGM(id);
    }

    public TheBeyond(AbstractPlayer p, SaveFile saveFile) {
        super(NAME, p, saveFile);
        CardCrawlGame.dungeon = this;
        if (scene != null) {
            scene.dispose();
        }
        scene = new TheBeyondScene();
        fadeColor = Color.valueOf("140a1eff");
        this.initializeLevelSpecificChances();
        CardCrawlGame.music.changeBGM(id);
        mapRng = new Random(Settings.seed, 200);
        TheBeyond.generateMap();
        firstRoomChosen = true;
        this.populatePathTaken(saveFile);
    }

    @Override
    protected void initializeLevelSpecificChances() {
        shopRoomChance = 0.05f;
        restRoomChance = 0.12f;
        treasureRoomChance = 0.0f;
        eventRoomChance = 0.22f;
        eliteRoomChance = 0.08f;
        smallChestChance = 50;
        mediumChestChance = 33;
        largeChestChance = 17;
        smallPotionChance = 50;
        mediumPotionChance = 50;
        largePotionChance = 0;
        commonRelicChance = 50;
        uncommonRelicChance = 33;
        rareRelicChance = 17;
        colorlessRareChance = 0.3f;
        cardUpgradedChance = 0.5f;
    }

    @Override
    protected void generateMonsters() {
        ArrayList<MonsterInfo> monsters = new ArrayList<MonsterInfo>();
        if (Settings.isBeta) {
            monsters.add(new MonsterInfo("Flame Bruiser 1 Orb", 2.0f));
        }
        monsters.add(new MonsterInfo("3 Darklings", 2.0f));
        monsters.add(new MonsterInfo("Orb Walker", 2.0f));
        monsters.add(new MonsterInfo("3 Shapes", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 2, false);
        monsters.clear();
        if (Settings.isBeta) {
            monsters.add(new MonsterInfo("Flame Bruiser 2 Orb", 1.0f));
            monsters.add(new MonsterInfo("Spire Growth", 1.0f));
        }
        monsters.add(new MonsterInfo("4 Shapes", 1.0f));
        monsters.add(new MonsterInfo("Maw", 1.0f));
        monsters.add(new MonsterInfo("Sphere and 2 Shapes", 1.0f));
        monsters.add(new MonsterInfo("3 Darklings", 1.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateFirstStrongEnemy(monsters, this.generateExclusions());
        this.populateMonsterList(monsters, 12, false);
        monsters.clear();
        monsters.add(new MonsterInfo("Giant Head", 2.0f));
        monsters.add(new MonsterInfo("Nemesis", 2.0f));
        monsters.add(new MonsterInfo("2 Orb Walkers", 2.0f));
        MonsterInfo.normalizeWeights(monsters);
        this.populateMonsterList(monsters, 5, true);
        logger.info("Random counter: " + TheBeyond.monsterRng.counter);
    }

    @Override
    protected ArrayList<String> generateExclusions() {
        ArrayList<String> retVal = new ArrayList<String>();
        switch ((String)monsterList.get(monsterList.size() - 1)) {
            case "Flame Bruiser 1 Orb": {
                retVal.add("Flame Bruiser 2 Orb");
                break;
            }
            case "3 Darklings": {
                retVal.add("3 Darklings");
                break;
            }
            case "Orb Walker": {
                retVal.add("Orb Walker");
                break;
            }
            case "3 Shapes": {
                retVal.add("4 Shapes");
                break;
            }
        }
        return retVal;
    }

    @Override
    protected void initializeBoss() {
        if (!UnlockTracker.isBossSeen("CROW")) {
            bossList.add("Awakened One");
        } else if (!UnlockTracker.isBossSeen("DONUT")) {
            bossList.add("Donu and Deca");
        } else if (!UnlockTracker.isBossSeen("WIZARD")) {
            bossList.add("Time Eater");
        } else {
            bossList.add("Awakened One");
            bossList.add("Time Eater");
            bossList.add("Donu and Deca");
            Collections.shuffle(bossList);
        }
    }

    @Override
    protected void initializeEventList() {
        eventList.add("Falling");
        eventList.add("The Moai Head");
        eventList.add("Mysterious Sphere");
        eventList.add("Tomb of Lord Red Mask");
        eventList.add("Winding Halls");
    }

    @Override
    protected void initializeEventImg() {
        if (eventImg != null) {
            eventImg.dispose();
            eventImg = null;
        }
        eventImg = ImageMaster.loadImage("images/ui/event/panel.png");
    }

    @Override
    protected void initializeShrineList() {
        shrineList.add("Match and Keep!");
        shrineList.add("Wheel of Change");
        shrineList.add("Golden Shrine");
        shrineList.add("Transmorgrifier");
        shrineList.add("Purifier");
        shrineList.add("Upgrade Shrine");
    }
}

